/*++

Copyright (c) 1996 Digital Equipment Corporation

Module Name:

    uhal.h

Abstract:

    User Master include for the uhal.lib for user mode I/O access. 

Author:

    Ed Serrano, Feb 23rd, 1997.

Revision History:

    Peter Lee, Jun 2, 1998. 	Added *_BUFFER_* routines.

--*/

//
// These are all the routines required for I/O access. These routines are valid
// only for user dense space mapping.
//

UCHAR
READ_REGISTER_UCHAR(
    PUCHAR Register
    );

USHORT
READ_REGISTER_USHORT(
    PUSHORT Register
    );

ULONG
READ_REGISTER_ULONG(
    PULONG Register
    );

VOID
WRITE_REGISTER_UCHAR(
    PUCHAR Register,
    UCHAR Value
    );

VOID
WRITE_REGISTER_USHORT(
    PUSHORT  Register,
    USHORT Value
    );

VOID
WRITE_REGISTER_ULONG(
    PULONG Register,
    ULONG Value
    );

//
// Buffer routines
//

VOID
READ_REGISTER_BUFFER_UCHAR(
    PUCHAR Register,
    PUCHAR Buffer,
    ULONG Count
    );

VOID
READ_REGISTER_BUFFER_USHORT(
    PUSHORT Register,
    PUSHORT Buffer,
    ULONG Count
    );

VOID
READ_REGISTER_BUFFER_ULONG(
    PULONG Register,
    PULONG Buffer,
    ULONG Count
    );

VOID
WRITE_REGISTER_BUFFER_UCHAR(
    PUCHAR Register,
    PUCHAR Buffer,
    ULONG Count
    );

VOID
WRITE_REGISTER_BUFFER_USHORT(
    PUSHORT Register,
    PUSHORT Buffer,
    ULONG Count
    );

VOID
WRITE_REGISTER_BUFFER_ULONG(
    PULONG Register,
    PULONG Buffer,
    ULONG Count
    );
